/**
 * Sample React Native App
 * https://github.com/facebook/react-native
 *
 * @format
 * @flow strict-local
 */

import { Node } from 'react';
import PaymentSDKPlugin from 'fortis-payment-sdk';
import React, { useState } from 'react';

import {
  SafeAreaView,
  ScrollView,
  StatusBar,
  StyleSheet,
  Text,
  useColorScheme,
  View,
  TouchableOpacity,
  DeviceEventEmitter,
  NativeEventEmitter,
  TextInput,
  Platform,
  KeyboardAvoidingView,
} from 'react-native';

import {
  Colors,
} from 'react-native/Libraries/NewAppScreen';

const App = () => {
  const isDarkMode = useColorScheme() === 'dark';

  const backgroundStyle = {
    backgroundColor: isDarkMode ? Colors.darker : Colors.lighter,
    padding: 8
  };

  const buttonStyle = {
    backgroundColor: 'blue', 
    padding: 10, 
    marginVertical: 5, 
    borderRadius: 5
  };

  const IDTECH_VP3300= "IDTECH-VP3300"
  const IDTECH_VP3300BT= IDTECH_VP3300+"BT"

  const authentication = {
    "header": {
      "developerId": "HwJd35Z6",
      "userId": "11ec11a758ee65caa5262645",
      "userAPIKey": "11ec43d3a43d43e483713f77",
      "protocol": "https",
      "hostname": "api.sandbox.zeamster.com",
      "apiEndpoint": "/v2/transactions",
      "authType": "apikey",
      "deviceType": IDTECH_VP3300BT,
    }
  }
  // Authentication with payload in another pointer to avoid changing the previous object
  const payload = Object.assign({}, authentication)
  payload.body = {
      "location_id":"11ec11a757d6b13897cd1f3c",
      "action": "sale",
      "payment_method": "cc",
      "transaction_type": "sale",
      "transaction_amount": "30.00",
      "enable_auth_deferred": "true",
    }

  // device name scanned by scanForDevices function(e.g. "IDTECH-VP3300-44547")
  const [deviceNameScanned, onDeviceNameChanged]  = useState(null)
  // auth deferred id fetched by
  const [authDeferredId, onAuthDeferredIdFound] = useState(null)

  const [action, onChangeAction] = useState('scanForDevices');
  const [input, onChangeInput] = useState(JSON.stringify([authentication, IDTECH_VP3300, 30]));
  const [consoleText, setConsoleText] = useState('');


  // region RN event - IMPORTANT! Events must be registered before a module is called
  // For reference the following article can be helpful: https://www.callstack.com/blog/sending-events-to-javascript-from-your-native-module-in-react-native 
  const onEventEmitted = (event) => {
    console.log(event);
    setConsoleText(event.status +' - '+ event.message);  

    if (action === "scanForDevices" && event.status === "OK" && event.message.indexOf("deviceScanResponse") !== -1) {
      //deviceScanResponse!@#$00:1C:97:1D:C5:14!@#$IDTECH-VP3300-44547
      const lastIndex = event.message.lastIndexOf("!@#$");

      if (lastIndex !== -1) {
        onDeviceNameChanged(event.message.substring(lastIndex + 4, event.message.length));
      }

    } 
  };

  // For an unkown reason it has to be different for each platform.
  const emitter = Platform.OS === 'ios' ? new NativeEventEmitter(PaymentSDKPlugin) : DeviceEventEmitter
  // Attention also to the action name. Actions not explicitly added won't trigger any listener
  emitter.addListener(action, onEventEmitted);
  // endregion RN event

  return (
    <SafeAreaView style={backgroundStyle}>
      <StatusBar barStyle={isDarkMode ? 'light-content' : 'dark-content'} />
      <ScrollView
        contentInsetAdjustmentBehavior="automatic"
        style={backgroundStyle}>
        <View
          style={{
            backgroundColor: isDarkMode ? Colors.black : Colors.white,
            padding: 8
          }}>
            <TouchableOpacity
              style={buttonStyle}
              onPress={() => {
                onChangeAction('scanForDevices');
                onChangeInput(JSON.stringify([authentication, IDTECH_VP3300, 30]));
              }}
            >
              <Text style={{ color: 'white' }}>Scan for Devices</Text>
            </TouchableOpacity>

            <TouchableOpacity
            style={buttonStyle}
            onPress={() => {
              onChangeAction('stopScanForDevices');
              onChangeInput('[]');
            }}
          >
            <Text style={{ color: 'white' }}>Stop scanning for devices</Text>
          </TouchableOpacity>

          <TouchableOpacity
            style={buttonStyle}
            onPress={() => {
              onChangeAction('connectDeviceByName');
              onChangeInput(JSON.stringify([deviceNameScanned]));
            }}
          >
            <Text style={{ color: 'white' }}>Connect by device name: {deviceNameScanned}</Text>
          </TouchableOpacity>

          <TouchableOpacity
            style={buttonStyle}
            onPress={() => {
              onChangeAction('disconnectDevice');
              onChangeInput('[]');
            }}
          >
            <Text style={{ color: 'white' }}>Disconnect device: {deviceNameScanned}</Text>
          </TouchableOpacity>

          <TouchableOpacity
            style={buttonStyle}
            onPress={() => {
              onChangeAction('performEMVTransaction');
              onChangeInput(JSON.stringify([payload]));
            }}
          >
            <Text style={{ color: 'white' }}>EMV Transaction</Text>
          </TouchableOpacity>

          <TouchableOpacity
            style={buttonStyle}
            onPress={() => {
              onChangeAction('fetchAuthDeferredList');
              onChangeInput('[]');
            }}
          >
            <Text style={{ color: 'white' }}>List Auth Deferred</Text>
          </TouchableOpacity>

          <TouchableOpacity
            style={buttonStyle}
            onPress={() => {
              onChangeAction('cancelAllAuthDeferredItems');
              onChangeInput('[]');
            }}
          >
            <Text style={{ color: 'white' }}>Cancel All Auth Deferred Items</Text>
          </TouchableOpacity>

          <TouchableOpacity
            style={buttonStyle}
            onPress={() => {
              onChangeAction('retryAuthDeferred');
              onChangeInput(JSON.stringify([authDeferredId]));
            }}
          >
            <Text style={{ color: 'white' }}>Retry Auth Deferred</Text>
          </TouchableOpacity>

          <Text>Action</Text>
           <TextInput
            placeholder="Action"
            value={action}
            multiline={false}
            onChangeText={onChangeAction}
          />
          <Text>Input</Text>
          <TextInput
            placeholder="Input params"
            multiline={true}
            value={input}
            onChangeText={onChangeInput}
          /> 
          <TouchableOpacity
            onPress={() => {
              setConsoleText('');
              PaymentSDKPlugin.execute(action, input);
            }}
            style={buttonStyle}
          >
            <Text style={{ color: 'white' }}>{`Execute - ${action}`}</Text>
          </TouchableOpacity>
          <Text style={{ color: 'white' }}>Output: {consoleText}</Text>
          
        </View>
      </ScrollView>
    </SafeAreaView>
  );
};

const styles = StyleSheet.create({
  sectionContainer: {
    marginTop: 32,
    paddingHorizontal: 24,
  },
  sectionTitle: {
    fontSize: 24,
    fontWeight: '600',
  },
  sectionDescription: {
    marginTop: 8,
    fontSize: 18,
    fontWeight: '400',
  },
  highlight: {
    fontWeight: '700',
  },
});

export default App;
